unit uMessSender;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, uMessageCommons;

type
  TForm1 = class(TForm)
    imPicture: TImage;
    edInteger: TEdit;
    mmText: TMemo;
    btnSendImage: TButton;
    btnSendInteger: TButton;
    btnSendString: TButton;
    OpenDialog1: TOpenDialog;
    procedure btnSendIntegerClick(Sender: TObject);
    procedure imPictureClick(Sender: TObject);
    procedure btnSendStringClick(Sender: TObject);
    procedure btnSendImageClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FPipe: THandle;
    { Private declarations }
    procedure SendData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.imPictureClick(Sender: TObject);
begin
   if OpenDialog1.Execute then
      imPicture.Picture.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.SendData(aData: TMemoryStream);
var
   _len: dword;
   _sz: integer;
begin
   { write the data size }
   _sz:= aData.Size;
   if not WriteFile(FPipe, _sz, 4, _len, nil) or (_len <> 4) then
      raise Exception.Create('failed to send data');
   { write the data }
   _len:= 0;
   if not WriteFile(FPipe, aData.memory^, aData.Size, _len, nil) or (_len <> aData.Size) then
      raise Exception.Create('failed to send data');
end;

procedure TForm1.btnSendIntegerClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtInteger);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _int:= StrToIntDef(edInteger.Text, 0);
      _msg.Write(_int, SizeOf(integer));
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendStringClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
   _ln: integer;
   _str: string;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtString);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _str:= mmText.Text;
      _ln:= length(_str);
      if (_ln > 0) then
         _msg.Write(_str[1], _ln);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendImageClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtImage);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      imPicture.Picture.Bitmap.SaveToStream(_msg);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   _pname: string;
   _i: integer;
   _wm: dword;
begin
   try
      { build the pipe name }
      _pname:= '\\' + '.' + '\pipe\' + 'testpipe';
      { try a few times to open it }
      for _i:= 0 to 99 do
         begin
            { create the file - pipe }
            FPipe := CreateFile(PChar(_pname), GENERIC_READ or GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);
            if (FPipe <> INVALID_HANDLE_VALUE) then
               Break;
            { we failed - check if we were busy }
            if (GetLastError <> ERROR_PIPE_BUSY) then
               raise Exception.Create(SysErrorMessage(GetLastError));
            { wait for a bit before retry - server was busy }
            if not WaitNamedPipe(PChar(_pname), 1000) then
               raise Exception.Create('Wait timeout error');
         end;
      { check if we have the pipe }
      if (FPipe = INVALID_HANDLE_VALUE) then
         raise Exception.Create('failed to open the pipe ');
      { set mode message and blocking mode }
      _wm:= PIPE_READMODE_MESSAGE or PIPE_WAIT;
      if not SetNamedPipeHandleState(FPipe, _wm, nil, nil) then
         raise Exception.Create('set state failed');
   except
      on e: exception do
         begin
            showmessage(e.Message);
            Application.Terminate;
         end;
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   { close the pipe }
   CloseHandle(FPipe);
end;

end.
